/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.combat;

import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.combat.threat.ThreatTableEntry;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TargetAI<T extends LivingEntity>
implements IStateAI {
    protected final T user;
    protected LivingEntity target;

    public TargetAI(T user, int targetFrequency, ITickRateStateMachine stateMachine) {
        this.user = user;
        stateMachine.addTransition(new TickingTransition<CombatAIStates>(CombatAIStates.NO_TARGET, this::checkForTarget, () -> CombatAIStates.ATTACKING, 5));
        stateMachine.addTransition(new TickingTransition<CombatAIStates>(CombatAIStates.NO_TARGET, this::searchNearbyTarget, () -> CombatAIStates.ATTACKING, targetFrequency));
    }

    protected boolean checkForTarget() {
        ThreatTableEntry nextTarget;
        if (this.target != null && !this.target.func_70089_S()) {
            this.onTargetDied(this.target);
            this.target = null;
        }
        if ((nextTarget = ((IThreatTableEntity)this.user).getThreatTable().getTarget()) == null) {
            return false;
        }
        if (this.isEntityValidTarget(nextTarget.getEntity())) {
            if (this.target != nextTarget.getEntity()) {
                this.target = nextTarget.getEntity();
                this.onTargetChange();
            }
            return true;
        }
        this.resetTarget();
        return false;
    }

    public boolean isEntityValidTarget(LivingEntity target) {
        if (target == this.user || target == null || !target.func_70089_S() || !this.isWithinPersecutionDistance(target)) {
            return false;
        }
        if (target == this.user.func_70643_av()) {
            return true;
        }
        return this.isAttackableTarget(target);
    }

    public void resetTarget() {
        if (this.target == null) {
            return;
        }
        if (this.user.func_110144_aD() == this.target) {
            this.user.func_130011_c(null);
        }
        if (this.user.func_70643_av() == this.target) {
            this.user.func_70604_c(null);
        }
        ((IThreatTableEntity)this.user).getThreatTable().markInvalidTarget();
        this.target = null;
    }

    protected boolean searchNearbyTarget() {
        if (this.checkForTarget()) {
            return true;
        }
        List entities = ((LivingEntity)this.user).field_70170_p.func_225317_b(LivingEntity.class, this.getSearchArea());
        if (entities.isEmpty()) {
            return false;
        }
        boolean foundTarget = false;
        for (LivingEntity entity : entities) {
            if (!entity.func_70089_S()) continue;
            if (this.skipSearch(entity)) {
                return false;
            }
            if (!this.isEntityValidTarget(entity)) continue;
            ((IThreatTableEntity)this.user).getThreatTable().addThreat(entity, 0);
            foundTarget = true;
        }
        return foundTarget;
    }

    protected boolean skipSearch(LivingEntity entity) {
        return false;
    }

    protected AxisAlignedBB getSearchArea() {
        BlockPos raiderPos = this.user.func_233580_cy_();
        Direction randomDirection = Direction.func_82600_a((int)(this.user.func_70681_au().nextInt(4) + 2));
        int searchRange = this.getSearchRange();
        double x1 = raiderPos.func_177958_n() + Math.max(searchRange * randomDirection.func_82601_c() + 16, 16);
        double x2 = raiderPos.func_177958_n() + Math.min(searchRange * randomDirection.func_82601_c() - 16, -16);
        double y1 = raiderPos.func_177956_o() + this.getYSearchRange();
        double y2 = raiderPos.func_177956_o() - this.getYSearchRange();
        double z1 = raiderPos.func_177952_p() + Math.max(searchRange * randomDirection.func_82599_e() + 16, 16);
        double z2 = raiderPos.func_177952_p() + Math.min(searchRange * randomDirection.func_82599_e() - 16, -16);
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    protected int getYSearchRange() {
        return 3;
    }

    protected int getSearchRange() {
        return 16;
    }

    protected boolean isAttackableTarget(LivingEntity target) {
        return target instanceof IMob && !this.user.getClass().isInstance(target);
    }

    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return true;
    }

    protected void onTargetDied(LivingEntity target) {
    }

    protected void onTargetChange() {
    }
}

